/* istanbul ignore next */
class AppLockdown {

    static disableContextMenu() {
        document.addEventListener('contextmenu', ev => {
            let elm = ev.target.nodeName.toLowerCase();
            if (elm === 'img' || elm === 'video' || elm === 'canvas' || window.getSelection().type === 'Range') {
                ev.preventDefault();
            }
        });
    }

    static disableEveryContextMenu() {
        document.addEventListener('contextmenu', ev => {
            ev.preventDefault();
        });
    }

    static disableDragDrop() {
        // Disable drag and drop (except inside the toolbox)
        document.addEventListener('dragstart', ev => {
            let contentEditable = this._findClosestElement(ev.target, "[contenteditable='true']");
            let contentDraggable = this._findClosestElement(ev.target, "[draggable='true']");
            if (!contentEditable && !contentDraggable) {
                ev.preventDefault();
            }
        });
    }

    static disableClipboard() {
        document.addEventListener('cut', ev => this._handleClipboardEvent(ev));
        document.addEventListener('copy', ev => this._handleClipboardEvent(ev));
        document.addEventListener('paste', ev => this._handleClipboardEvent(ev));
    }

    static disableShortcuts() {
        window.addEventListener('keydown', ev => this._preventKeyShortcut(ev));
        window.addEventListener('keyup', ev => this._preventKeyShortcut(ev));

        window.addEventListener('mousedown', ev => this._preventMouseShortcut(ev));
        window.addEventListener('mouseup', ev => this._preventMouseShortcut(ev));
    }

    static _handleClipboardEvent(ev) {
        let elm = ev.target.nodeName.toLowerCase();
        let isTextInput = elm === 'input' || elm === 'textarea';
        let isContentEditable = this._findClosestElement(ev.target, "[contenteditable='true']") !== null;
        let isArticle = this._findClosestElement(ev.target, 'article') !== null;

        // conditions should probably match with conditions in player (contextMenu.js, method contextMenuOpen())
        if (!isTextInput && !isContentEditable && !isArticle) {
            // stop handling here
            ev.stopPropagation();
            // cancel event
            ev.preventDefault();
        }
    }

    static _findClosestElement(el, selector) {
        while (el !== null) {
            if (el.nodeType === 1) { // skip text-nodes
                return el.closest(selector);
            }
            el = el.parentElement;
        }

        return null;
    }

    static _preventKeyShortcut(ev) {
        if (ev.keyCode === 166 || ev.keyCode === 167) { // browser back and forward multimedia keys
            ev.preventDefault();
        }
    }

    static _preventMouseShortcut(ev) {
        if (ev.button === 3 || ev.button === 4) { // extra mouse buttons used for browser back and forward
            ev.preventDefault();
        }
    }
}

AppLockdown.disableContextMenu();
AppLockdown.disableDragDrop();
